
/*:
 * @plugindesc アイテム入手時、上限から溢れた個数に応じてゴールドを獲得します。
 * 
 * @author LefTonbo
 *
 * @help
 * <NoMoneyConvert> がメタ情報にあるアイテムはゴールドに変換されません。
 *
 */

(function(){

//=============================================================================
// Game_Party
//=============================================================================

var _Game_Party_gainItem = Game_Party.prototype.gainItem;
Game_Party.prototype.gainItem = function(item, amount, includeEquip) {
  if (!item || item.meta.NoMoneyConvert) {
    return _Game_Party_gainItem.apply(this, arguments);
  }
  // アイテムゲット前の所持数を保存
  var itemHave = this.numItems(item);
  // アイテム入手処理呼び出し
  _Game_Party_gainItem.apply(this, arguments);
  // 以下が追加
  var overHave = (itemHave + amount) - this.maxItems(item);
  var price = 0;
  if (overHave > 0){
    price = item.price;
  }
  if (price > 0) this.gainGold(price * overHave);
};

//=============================================================================

}());

// EOF
